/*===========================================================================
    C++ class definitions exported from UnrealScript.
    This is automatically generated by the tools.
    DO NOT modify this manually! Edit the corresponding .uc files instead!
===========================================================================*/
#if SUPPORTS_PRAGMA_PACK
#pragma pack (push,8)
#endif

#ifndef ONSLAUGHT_API
#define ONSLAUGHT_API DLL_IMPORT
#endif

#ifndef NAMES_ONLY
#define AUTOGENERATE_NAME(name) extern ONSLAUGHT_API FName ONSLAUGHT_##name;
#define AUTOGENERATE_FUNCTION(cls,idx,name)
#endif

AUTOGENERATE_NAME(ApplyFireImpulse)
AUTOGENERATE_NAME(AttemptFire)
AUTOGENERATE_NAME(CheckReset)
AUTOGENERATE_NAME(ClientSpawnHitEffects)
AUTOGENERATE_NAME(ClientVehicleExplosion)
AUTOGENERATE_NAME(DestroyAppearance)
AUTOGENERATE_NAME(DetonateWeb)
AUTOGENERATE_NAME(FlashMuzzleFlash)
AUTOGENERATE_NAME(Jumping)
AUTOGENERATE_NAME(JumpOutCheck)
AUTOGENERATE_NAME(OnDaredevil)
AUTOGENERATE_NAME(OwnerEffects)
AUTOGENERATE_NAME(SetEmitterStatus)
AUTOGENERATE_NAME(TakeImpactDamage)
AUTOGENERATE_NAME(UpdateDamagedEffect)
AUTOGENERATE_NAME(UpdateSparks)

#ifndef NAMES_ONLY

struct ONSLAUGHT_API FDriverWeaponStruct
{
    class UClass* WeaponClass GCC_PACK(8);
    FName WeaponBone;
    friend ONSLAUGHT_API FArchive& operator<<(FArchive& Ar,FDriverWeaponStruct& MyDriverWeaponStruct)
    {
        return Ar << MyDriverWeaponStruct.WeaponClass << MyDriverWeaponStruct.WeaponBone;
    }
};

struct ONSLAUGHT_API FPassengerWeaponStruct
{
    class UClass* WeaponPawnClass GCC_PACK(8);
    FName WeaponBone;
    friend ONSLAUGHT_API FArchive& operator<<(FArchive& Ar,FPassengerWeaponStruct& MyPassengerWeaponStruct)
    {
        return Ar << MyPassengerWeaponStruct.WeaponPawnClass << MyPassengerWeaponStruct.WeaponBone;
    }
};

struct ONSLAUGHT_API FImpactInfoStruct
{
    class AActor* Other GCC_PACK(8);
    FVector pos;
    FVector impactVel;
    FVector impactNorm;
    FVector ImpactAccel;
    friend ONSLAUGHT_API FArchive& operator<<(FArchive& Ar,FImpactInfoStruct& MyImpactInfoStruct)
    {
        return Ar << MyImpactInfoStruct.Other << MyImpactInfoStruct.pos << MyImpactInfoStruct.impactVel << MyImpactInfoStruct.impactNorm << MyImpactInfoStruct.ImpactAccel;
    }
};


struct AONSVehicle_eventClientVehicleExplosion_Parms
{
    BITFIELD bFinal;
};
struct AONSVehicle_eventDestroyAppearance_Parms
{
};
struct AONSVehicle_eventApplyFireImpulse_Parms
{
    BITFIELD bAlt;
};
struct AONSVehicle_eventTakeImpactDamage_Parms
{
    FLOAT AccelMag;
};
struct AONSVehicle_eventCheckReset_Parms
{
};
class ONSLAUGHT_API AONSVehicle : public ASVehicle
{
public:
    TArrayNoInit<FDriverWeaponStruct> DriverWeapons GCC_PACK(8);
    TArrayNoInit<class AONSWeapon*> Weapons;
    TArrayNoInit<FPassengerWeaponStruct> PassengerWeapons;
    TArrayNoInit<class AONSWeaponPawn*> WeaponPawns;
    BYTE ActiveWeapon;
    FRotator CustomAim GCC_PACK(4);
    BITFIELD bHasAltFire:1 GCC_PACK(4);
    class UMaterial* RedSkin GCC_PACK(8);
    class UMaterial* BlueSkin;
    class USound* IdleSound;
    class USound* StartUpSound;
    class USound* ShutDownSound;
    FStringNoInit StartUpForce;
    FStringNoInit ShutDownForce;
    FLOAT ViewShakeRadius;
    FRotator ViewShakeRotMag;
    FLOAT ViewShakeRotFreq;
    FVector ViewShakeOffsetMag;
    FLOAT ViewShakeOffsetFreq;
    FLOAT ViewShakeLastCheck;
    class UStaticMesh* DestroyedVehicleMesh;
    class UClass* DestructionEffectClass;
    class UClass* DisintegrationEffectClass;
    FLOAT DisintegrationHealth;
    FRange DestructionLinearMomentum;
    FRange DestructionAngularMomentum;
    FLOAT TimeBetweenImpactExplosions;
    TArrayNoInit<class USound*> ExplosionSounds;
    FLOAT ExplosionSoundVolume;
    FLOAT ExplosionSoundRadius;
    BYTE ExplosionCount;
    BYTE OldExplosionCount;
    FLOAT LastVelocitySize GCC_PACK(4);
    FLOAT LastImpactExplosionTime;
    FLOAT LastCheckUpsideDownTime;
    FLOAT UpsideDownDamage;
    FLOAT ExplosionDamage;
    FLOAT ExplosionRadius;
    FLOAT ExplosionMomentum;
    class UClass* ExplosionDamageType;
    class UClass* DestroyedRoadKillDamageType;
    class UClass* DamagedEffectClass;
    FLOAT DamagedEffectScale;
    FVector DamagedEffectOffset;
    FLOAT DamagedEffectHealthSmokeFactor;
    FLOAT DamagedEffectHealthFireFactor;
    FLOAT DamagedEffectAccScale;
    FLOAT DamagedEffectFireDamagePerSec;
    FLOAT DamagedEffectAccruedDamage;
    class AONSDamagedEffect* DamagedEffect;
    BITFIELD bDestroyAppearance:1 GCC_PACK(4);
    BITFIELD bDisintegrateVehicle:1;
    BITFIELD bHadFire:1;
    BITFIELD bEnableProximityViewShake:1;
    BITFIELD bOnlyViewShakeIfDriven:1;
    BITFIELD bSoundsPrecached:1;
    BITFIELD bNeverReset:1;
    BITFIELD bEjectPassengersWhenFlipped:1;
    BITFIELD bDriverCannotLeaveVehicle:1;
    BITFIELD bCannotBeBased:1;
    FVector FireImpulse GCC_PACK(4);
    FVector AltFireImpulse;
    BITFIELD bHasFireImpulse:1 GCC_PACK(4);
    BITFIELD bHasAltFireImpulse:1;
    BITFIELD bCustomAiming:1;
    BITFIELD bIsAwake:1;
    BITFIELD bHasBeenAwake:1;
    BITFIELD bAltFocalPoint:1;
    FVector AltFocalPoint GCC_PACK(4);
    FVector ShakeRotMag;
    FVector ShakeRotRate;
    FLOAT ShakeRotTime;
    FVector ShakeOffsetMag;
    FVector ShakeOffsetRate;
    FLOAT ShakeOffsetTime;
    FImpactInfoStruct ImpactInfo;
    INT ImpactTicksLeft;
    FLOAT ImpactDamageTicks;
    FLOAT ImpactDamageThreshold;
    FLOAT ImpactDamageMult;
    TArrayNoInit<class USound*> ImpactDamageSounds;
    class UClass* SparkEffectClass;
    class AONSImpactSparks* SparkEffect;
    FLOAT SparkAdvanceFactor;
    TArrayNoInit<class AONSHeadlightCorona*> HeadlightCorona;
    TArrayNoInit<FVector> HeadlightCoronaOffset;
    class UMaterial* HeadlightCoronaMaterial;
    FLOAT HeadlightCoronaMaxSize;
    class AONSHeadlightProjector* HeadlightProjector;
    class UMaterial* HeadlightProjectorMaterial;
    FVector HeadlightProjectorOffset;
    FRotator HeadlightProjectorRotation;
    FLOAT HeadlightProjectorScale;
    FStringNoInit DebugInfo;
    class USound* LockedOnSound;
    FLOAT ResetTime;
    FLOAT LastRunOverWarningTime;
    FLOAT MinRunOverWarningAim;
    class ABot* Reservation;
    INT OldYaw;
    FColor CrossHairColor;
    FLOAT CrosshairX;
    FLOAT CrosshairY;
    class UTexture* CrosshairTexture;
    void eventClientVehicleExplosion(BITFIELD bFinal)
    {
        AONSVehicle_eventClientVehicleExplosion_Parms Parms;
        Parms.bFinal=((bFinal) ? FIRST_BITFIELD : 0);
        ProcessEvent(FindFunctionChecked(ONSLAUGHT_ClientVehicleExplosion),&Parms);
    }
    void eventDestroyAppearance()
    {
        ProcessEvent(FindFunctionChecked(ONSLAUGHT_DestroyAppearance),NULL);
    }
    void eventApplyFireImpulse(BITFIELD bAlt)
    {
        AONSVehicle_eventApplyFireImpulse_Parms Parms;
        Parms.bAlt=((bAlt) ? FIRST_BITFIELD : 0);
        ProcessEvent(FindFunctionChecked(ONSLAUGHT_ApplyFireImpulse),&Parms);
    }
    void eventTakeImpactDamage(FLOAT AccelMag)
    {
        AONSVehicle_eventTakeImpactDamage_Parms Parms;
        Parms.AccelMag=AccelMag;
        ProcessEvent(FindFunctionChecked(ONSLAUGHT_TakeImpactDamage),&Parms);
    }
    void eventCheckReset()
    {
        ProcessEvent(FindFunctionChecked(ONSLAUGHT_CheckReset),NULL);
    }
    DECLARE_CLASS(AONSVehicle,ASVehicle,0|CLASS_Config|CLASS_NativeReplication,Onslaught)
	virtual INT* GetOptimizedRepList(BYTE* Recent, FPropertyRetirement* Retire, INT* Ptr, UPackageMap* Map, UActorChannel* Channel);
	virtual UBOOL Tick(FLOAT DeltaTime, enum ELevelTick TickType);
	virtual UBOOL KRepulsorsShouldHit(AActor* Actor);
	virtual void PostNetReceive();
	virtual void SetBase(AActor* NewBase, FVector NewFloor, int bNotifyActor);
};

struct ONSLAUGHT_API FSCarState
{
    FVector ChassisPosition GCC_PACK(4);
    FQuat ChassisQuaternion;
    FVector ChassisLinVel;
    FVector ChassisAngVel;
    BYTE ServerHandbrake;
    BYTE ServerBrake;
    BYTE ServerGas;
    BYTE ServerGear;
    BYTE ServerSteering;
    INT ServerViewPitch GCC_PACK(4);
    INT ServerViewYaw;
};


struct AONSWheeledCraft_eventOnDaredevil_Parms
{
};
struct AONSWheeledCraft_eventJumping_Parms
{
};
class ONSLAUGHT_API AONSWheeledCraft : public AONSVehicle
{
public:
    FLOAT WheelSoftness GCC_PACK(4);
    FLOAT WheelPenScale;
    FLOAT WheelPenOffset;
    FLOAT WheelRestitution;
    FLOAT WheelAdhesion;
    FLOAT WheelInertia;
    FInterpCurve WheelLongFrictionFunc;
    FLOAT WheelLongSlip;
    FInterpCurve WheelLatSlipFunc;
    FLOAT WheelLongFrictionScale;
    FLOAT WheelLatFrictionScale;
    FLOAT WheelHandbrakeSlip;
    FLOAT WheelHandbrakeFriction;
    FLOAT WheelSuspensionTravel;
    FLOAT WheelSuspensionOffset;
    FLOAT WheelSuspensionMaxRenderTravel;
    FLOAT FTScale;
    FLOAT ChassisTorqueScale;
    FLOAT MinBrakeFriction;
    FInterpCurve MaxSteerAngleCurve;
    FInterpCurve TorqueCurve;
    FLOAT GearRatios[5];
    INT NumForwardGears;
    FLOAT TransRatio;
    FLOAT ChangeUpPoint;
    FLOAT ChangeDownPoint;
    FLOAT LSDFactor;
    FLOAT EngineBrakeFactor;
    FLOAT EngineBrakeRPMScale;
    FLOAT MaxBrakeTorque;
    FLOAT SteerSpeed;
    FLOAT TurnDamping;
    FLOAT StopThreshold;
    FLOAT HandbrakeThresh;
    FLOAT EngineInertia;
    FLOAT IdleRPM;
    FLOAT EngineRPMSoundRange;
    FName SteerBoneName;
    BYTE SteerBoneAxis;
    FLOAT SteerBoneMaxAngle GCC_PACK(4);
    TArrayNoInit<class AONSDirtSlipEffect*> Dust;
    FLOAT DustSlipRate;
    FLOAT DustSlipThresh;
    FLOAT OutputBrake;
    FLOAT OutputGas;
    BITFIELD OutputHandbrake:1 GCC_PACK(4);
    INT Gear GCC_PACK(4);
    FLOAT ForwardVel;
    BITFIELD bIsInverted:1 GCC_PACK(4);
    BITFIELD bIsDriving:1;
    FLOAT NumPoweredWheels GCC_PACK(4);
    FLOAT TotalSpinVel;
    FLOAT EngineRPM;
    FLOAT CarMPH;
    FLOAT ActualSteering;
    class UMaterial* RevMeterMaterial;
    FLOAT RevMeterPosX;
    FLOAT RevMeterPosY;
    FLOAT RevMeterScale;
    FLOAT RevMeterSizeY;
    BITFIELD bMakeBrakeLights:1 GCC_PACK(4);
    FVector BrakeLightOffset[2] GCC_PACK(4);
    class AONSBrakelightCorona* BrakeLight[2];
    class UMaterial* BrakeLightMaterial;
    FRotator OldRotation;
    FVector LastOnGroundLocation;
    FLOAT LastOnGroundTime;
    FLOAT InAirSpin;
    FLOAT InAirPitch;
    FLOAT InAirRoll;
    FLOAT InAirTime;
    FLOAT InAirDistance;
    INT DaredevilPoints;
    FLOAT DaredevilThreshInAirSpin;
    FLOAT DaredevilThreshInAirPitch;
    FLOAT DaredevilThreshInAirRoll;
    FLOAT DaredevilThreshInAirTime;
    FLOAT DaredevilThreshInAirDistance;
    class UClass* DaredevilMessageClass;
    FSCarState CarState;
    FSCarState OldCarState;
    FKRigidBodyState ChassisState;
    BITFIELD bNewCarState:1 GCC_PACK(4);
    BITFIELD bOldVehicleOnGround:1;
    BITFIELD bDoStuntInfo:1;
    BITFIELD bAllowAirControl:1;
    BITFIELD bAllowChargingJump:1;
    BITFIELD bAllowBigWheels:1;
    BITFIELD bPushDown:1;
    FLOAT MaxJumpForce GCC_PACK(4);
    FLOAT JumpForce;
    FLOAT MaxJumpSpin;
    FLOAT JumpSpin;
    FLOAT JumpChargeTime;
    FLOAT DesiredJumpForce;
    FStringNoInit JumpFeedbackForce;
    class USound* JumpSound;
    FLOAT JumpMeterOriginX;
    FLOAT JumpMeterOriginY;
    FLOAT JumpMeterWidth;
    FLOAT JumpMeterHeight;
    FLOAT JumpMeterSpacing;
    FColor JumpMeterColor;
    FColor SpinMeterColor;
    class UTexture* JumpMeterTexture;
    FLOAT OutputPitch;
    FLOAT AirTurnTorque;
    FLOAT AirPitchTorque;
    FLOAT AirPitchDamping;
    FLOAT AirRollTorque;
    FLOAT AirRollDamping;
    FLOAT MinAirControlDamping;
    FLOAT FenderBenderSpeed;
    void eventOnDaredevil()
    {
        ProcessEvent(FindFunctionChecked(ONSLAUGHT_OnDaredevil),NULL);
    }
    void eventJumping()
    {
        ProcessEvent(FindFunctionChecked(ONSLAUGHT_Jumping),NULL);
    }
    DECLARE_CLASS(AONSWheeledCraft,AONSVehicle,0|CLASS_Config|CLASS_NativeReplication,Onslaught)
	INT* GetOptimizedRepList(BYTE* Recent, FPropertyRetirement* Retire, INT* Ptr, UPackageMap* Map, UActorChannel* Channel);

#ifdef WITH_KARMA
	// Actor interface.
	virtual UBOOL Tick(FLOAT DeltaTime, enum ELevelTick TickType);
	virtual void preKarmaStep(FLOAT DeltaTime);
	virtual void PostNetReceive();

	// SVehicle interface.
	virtual void UpdateVehicle(FLOAT DeltaTime);

	// SCar interface.
	virtual void ProcessCarInput();
	virtual void ChangeGear(UBOOL bReverse);
	virtual void PackState();
#endif
};

struct ONSLAUGHT_API FTreadCraftState
{
    FVector ChassisPosition GCC_PACK(4);
    FQuat ChassisQuaternion;
    FVector ChassisLinVel;
    FVector ChassisAngVel;
    BYTE ServerThrust;
    BYTE ServerTurn;
    INT ServerViewPitch GCC_PACK(4);
    INT ServerViewYaw;
};


class ONSLAUGHT_API AONSTreadCraft : public AONSVehicle
{
public:
    TArrayNoInit<FVector> ThrusterOffsets GCC_PACK(8);
    FLOAT HoverSoftness;
    FLOAT HoverPenScale;
    FLOAT HoverCheckDist;
    FLOAT UprightStiffness;
    FLOAT UprightDamping;
    FLOAT MaxThrust;
    FLOAT MaxSteerTorque;
    FLOAT ForwardDampFactor;
    FLOAT TurnDampFactor;
    FLOAT LateralDampFactor;
    FLOAT ParkingDampFactor;
    FLOAT SteerDampFactor;
    FLOAT PitchTorqueFactor;
    FLOAT PitchDampFactor;
    FLOAT BankTorqueFactor;
    FLOAT BankDampFactor;
    FLOAT InvertSteeringThrottleThreshold;
    class UMaterial* MPHMeterMaterial;
    FLOAT MPHMeterPosX;
    FLOAT MPHMeterPosY;
    FLOAT MPHMeterScale;
    FLOAT MPHMeterSizeY;
    FLOAT BikeMPH;
    FLOAT OutputThrust;
    FLOAT OutputTurn;
    FTreadCraftState TreadState;
    FTreadCraftState OldTreadState;
    FKRigidBodyState ChassisState;
    BITFIELD bNewTreadState:1 GCC_PACK(4);
    DECLARE_CLASS(AONSTreadCraft,AONSVehicle,0|CLASS_Config|CLASS_NativeReplication,Onslaught)
	INT* GetOptimizedRepList(BYTE* Recent, FPropertyRetirement* Retire, INT* Ptr, UPackageMap* Map, UActorChannel* Channel);

#ifdef WITH_KARMA
	// Actor interface.
	virtual UBOOL Tick(FLOAT DeltaTime, enum ELevelTick TickType);
	virtual void PostNetReceive();

	// SVehicle interface.
	virtual void UpdateVehicle(FLOAT DeltaTime);

	// SHover interface.
	virtual void PackState();
#endif
};

struct ONSLAUGHT_API FPlaneStateStruct
{
    FKRBVec ChassisPosition GCC_PACK(4);
    FQuat ChassisQuaternion;
    FKRBVec ChassisLinVel;
    FKRBVec ChassisAngVel;
    FLOAT ServerThrust;
    FLOAT ServerStrafe;
    FLOAT ServerRise;
    INT ServerViewPitch;
    INT ServerViewYaw;
};


class ONSLAUGHT_API AONSPlaneCraft : public AONSVehicle
{
public:
    FInterpCurve LiftCoefficientCurve GCC_PACK(8);
    FInterpCurve DragCoefficientCurve;
    FLOAT AirFactor;
    FLOAT MaxThrust;
    FLOAT ThrustAcceleration;
    BITFIELD bHoverOnGround:1 GCC_PACK(4);
    FLOAT COMHeight GCC_PACK(4);
    FInterpCurve HoverForceCurve;
    FLOAT CameraSwingRatio;
    FLOAT CameraDistance;
    TArrayNoInit<FVector> ThrusterOffsets;
    FLOAT HoverSoftness;
    FLOAT HoverPenScale;
    FLOAT HoverCheckDist;
    FLOAT OutputThrust;
    FLOAT OutputStrafe;
    FLOAT OutputRise;
    FLOAT CurrentThrust;
    FLOAT AccumulatedTime;
    FLOAT LastCamTime;
    FRotator LastCamRot;
    FLOAT PitchTorque;
    FLOAT BankTorque;
    FPlaneStateStruct PlaneState;
    FPlaneStateStruct OldPlaneState;
    FKRigidBodyState ChassisState;
    BITFIELD bNewPlaneState:1 GCC_PACK(4);
    DECLARE_CLASS(AONSPlaneCraft,AONSVehicle,0|CLASS_Config|CLASS_NativeReplication,Onslaught)
	INT* GetOptimizedRepList(BYTE* Recent, FPropertyRetirement* Retire, INT* Ptr, UPackageMap* Map, UActorChannel* Channel);

#ifdef WITH_KARMA
	// Actor interface.
	virtual UBOOL Tick(FLOAT DeltaTime, enum ELevelTick TickType);
	virtual void PostNetReceive();

	// SVehicle interface.
	virtual void UpdateVehicle(FLOAT DeltaTime);

	// SHover interface.
	virtual void PackState();
#endif
};

struct ONSLAUGHT_API FHoverCraftState
{
    FVector ChassisPosition GCC_PACK(4);
    FQuat ChassisQuaternion;
    FVector ChassisLinVel;
    FVector ChassisAngVel;
    BYTE ServerThrust;
    BYTE ServerStrafe;
    INT ServerViewPitch GCC_PACK(4);
    INT ServerViewYaw;
};


class ONSLAUGHT_API AONSHoverCraft : public AONSVehicle
{
public:
    TArrayNoInit<FVector> ThrusterOffsets GCC_PACK(8);
    FLOAT HoverSoftness;
    FLOAT HoverPenScale;
    FLOAT HoverCheckDist;
    FLOAT UprightStiffness;
    FLOAT UprightDamping;
    FLOAT MaxThrustForce;
    FLOAT LongDamping;
    FLOAT MaxStrafeForce;
    FLOAT LatDamping;
    FLOAT MaxRiseForce;
    FLOAT UpDamping;
    FLOAT TurnTorqueFactor;
    FLOAT TurnTorqueMax;
    FLOAT TurnDamping;
    FLOAT MaxYawRate;
    FLOAT PitchTorqueFactor;
    FLOAT PitchTorqueMax;
    FLOAT PitchDamping;
    FLOAT RollTorqueTurnFactor;
    FLOAT RollTorqueStrafeFactor;
    FLOAT RollTorqueMax;
    FLOAT RollDamping;
    FLOAT StopThreshold;
    FLOAT MaxRandForce;
    FLOAT RandForceInterval;
    FLOAT HoverMPH;
    FLOAT TargetHeading;
    FLOAT TargetPitch;
    BITFIELD bHeadingInitialized:1 GCC_PACK(4);
    FLOAT OutputThrust GCC_PACK(4);
    FLOAT OutputStrafe;
    class APawn* OldDriver;
    FHoverCraftState HoverState;
    FHoverCraftState OldHoverState;
    FKRigidBodyState ChassisState;
    BITFIELD bNewHoverState:1 GCC_PACK(4);
    DECLARE_CLASS(AONSHoverCraft,AONSVehicle,0|CLASS_Config|CLASS_NativeReplication,Onslaught)
	INT* GetOptimizedRepList(BYTE* Recent, FPropertyRetirement* Retire, INT* Ptr, UPackageMap* Map, UActorChannel* Channel);

#ifdef WITH_KARMA
	// Actor interface.
	virtual UBOOL Tick(FLOAT DeltaTime, enum ELevelTick TickType);
	virtual void PostNetReceive();
	virtual UBOOL KRepulsorsShouldHit(AActor* Actor);

	// SVehicle interface.
	virtual void UpdateVehicle(FLOAT DeltaTime);

	// SHover interface.
	virtual void PackState();
#endif
};

struct ONSLAUGHT_API FCopterState
{
    FVector ChassisPosition GCC_PACK(4);
    FQuat ChassisQuaternion;
    FVector ChassisLinVel;
    FVector ChassisAngVel;
    BYTE ServerThrust;
    BYTE ServerStrafe;
    BYTE ServerRise;
    INT ServerViewPitch GCC_PACK(4);
    INT ServerViewYaw;
};


struct AONSChopperCraft_eventJumpOutCheck_Parms
{
};
class ONSLAUGHT_API AONSChopperCraft : public AONSVehicle
{
public:
    FLOAT UprightStiffness GCC_PACK(4);
    FLOAT UprightDamping;
    FLOAT MaxThrustForce;
    FLOAT LongDamping;
    FLOAT MaxStrafeForce;
    FLOAT LatDamping;
    FLOAT MaxRiseForce;
    FLOAT UpDamping;
    FLOAT TurnTorqueFactor;
    FLOAT TurnTorqueMax;
    FLOAT TurnDamping;
    FLOAT MaxYawRate;
    FLOAT PitchTorqueFactor;
    FLOAT PitchTorqueMax;
    FLOAT PitchDamping;
    FLOAT RollTorqueTurnFactor;
    FLOAT RollTorqueStrafeFactor;
    FLOAT RollTorqueMax;
    FLOAT RollDamping;
    FLOAT StopThreshold;
    FLOAT MaxRandForce;
    FLOAT RandForceInterval;
    FLOAT CopterMPH;
    FLOAT TargetHeading;
    FLOAT TargetPitch;
    BITFIELD bHeadingInitialized:1 GCC_PACK(4);
    FLOAT OutputThrust GCC_PACK(4);
    FLOAT OutputStrafe;
    FLOAT OutputRise;
    FVector RandForce;
    FVector RandTorque;
    FLOAT AccumulatedTime;
    FCopterState CopState;
    FCopterState OldCopState;
    FKRigidBodyState ChassisState;
    BITFIELD bNewCopterState:1 GCC_PACK(4);
    FLOAT PushForce GCC_PACK(4);
    FLOAT LastJumpOutCheck;
    void eventJumpOutCheck()
    {
        ProcessEvent(FindFunctionChecked(ONSLAUGHT_JumpOutCheck),NULL);
    }
    DECLARE_CLASS(AONSChopperCraft,AONSVehicle,0|CLASS_Config|CLASS_NativeReplication,Onslaught)
	INT* GetOptimizedRepList(BYTE* Recent, FPropertyRetirement* Retire, INT* Ptr, UPackageMap* Map, UActorChannel* Channel);
	virtual UBOOL AdjustFlight(FLOAT ZDiff, UBOOL bFlyingDown, FLOAT Distance, AActor* GoalActor);

#ifdef WITH_KARMA
	// Actor interface.
	virtual UBOOL Tick(FLOAT DeltaTime, enum ELevelTick TickType);
	virtual void PostNetReceive();

	// SVehicle interface.
	virtual void UpdateVehicle(FLOAT DeltaTime);

	// SHover interface.
	virtual void PackState();
#endif
};

#define UCONST_FilterFrames 5

struct AONSWeaponPawn_eventApplyFireImpulse_Parms
{
    BITFIELD bAlt;
};
class ONSLAUGHT_API AONSWeaponPawn : public AVehicle
{
public:
    FVector GunnerPos GCC_PACK(4);
    FRotator GunnerRot;
    FVector FireImpulse;
    FVector AltFireImpulse;
    class AONSWeapon* Gun;
    class UClass* GunClass;
    class AONSVehicle* VehicleBase;
    class UClass* DestroyEffectClass;
    FVector CameraHistory[5];
    INT NextHistorySlot;
    BITFIELD bHistoryWarmup:1 GCC_PACK(4);
    BITFIELD bHasFireImpulse:1;
    BITFIELD bHasAltFireImpulse:1;
    BITFIELD bCustomAiming:1;
    FRotator CustomAim GCC_PACK(4);
    FLOAT YawAccel;
    FLOAT PitchAccel;
    FStringNoInit DebugInfo;
    BITFIELD bHasOwnHealth:1 GCC_PACK(4);
    BITFIELD bHasAltFire:1;
    FName CameraBone GCC_PACK(4);
    FColor CrossHairColor;
    FLOAT CrosshairX;
    FLOAT CrosshairY;
    class UTexture* CrosshairTexture;
    void eventApplyFireImpulse(BITFIELD bAlt)
    {
        AONSWeaponPawn_eventApplyFireImpulse_Parms Parms;
        Parms.bAlt=((bAlt) ? FIRST_BITFIELD : 0);
        ProcessEvent(FindFunctionChecked(ONSLAUGHT_ApplyFireImpulse),&Parms);
    }
    DECLARE_CLASS(AONSWeaponPawn,AVehicle,0|CLASS_Config|CLASS_NativeReplication,Onslaught)
	INT* GetOptimizedRepList(BYTE* Recent, FPropertyRetirement* Retire, INT* Ptr, UPackageMap* Map, UActorChannel* Channel);
	virtual UBOOL ReachedDesiredRotation();
	virtual UBOOL Tick(FLOAT DeltaTime, enum ELevelTick TickType);
	virtual UBOOL SharingVehicleWith(APawn *P);
    virtual BUGGYINLINE UBOOL IsJoinedTo( const AActor *Other) const;
	virtual APawn* GetVehicleBase();
};


class ONSLAUGHT_API AONSHeadlightProjector : public AProjector
{
public:
    DECLARE_CLASS(AONSHeadlightProjector,AProjector,0,Onslaught)
    NO_DEFAULT_CONSTRUCTOR(AONSHeadlightProjector)
};


struct AONSWeaponAmbientEmitter_eventSetEmitterStatus_Parms
{
    BITFIELD bEnabled;
};
class ONSLAUGHT_API AONSWeaponAmbientEmitter : public AEmitter
{
public:
    void eventSetEmitterStatus(BITFIELD bEnabled)
    {
        AONSWeaponAmbientEmitter_eventSetEmitterStatus_Parms Parms;
        Parms.bEnabled=((bEnabled) ? FIRST_BITFIELD : 0);
        ProcessEvent(FindFunctionChecked(ONSLAUGHT_SetEmitterStatus),&Parms);
    }
    DECLARE_CLASS(AONSWeaponAmbientEmitter,AEmitter,0,Onslaught)
    NO_DEFAULT_CONSTRUCTOR(AONSWeaponAmbientEmitter)
};


struct AONSImpactSparks_eventUpdateSparks_Parms
{
    FLOAT SparkRadius;
    FVector VehicleVelocity;
};
class ONSLAUGHT_API AONSImpactSparks : public AEmitter
{
public:
    FLOAT HorizontalVelocityRange GCC_PACK(4);
    FLOAT AdditionalVelocityScale;
    FLOAT MaxAdditionalVelocity;
    FLOAT SparkRadiusScale;
    FInterpCurve SparkRate;
    class USound* ScrapeSound;
    BITFIELD bSparksActive:1 GCC_PACK(4);
    void eventUpdateSparks(FLOAT SparkRadius, FVector VehicleVelocity)
    {
        AONSImpactSparks_eventUpdateSparks_Parms Parms;
        Parms.SparkRadius=SparkRadius;
        Parms.VehicleVelocity=VehicleVelocity;
        ProcessEvent(FindFunctionChecked(ONSLAUGHT_UpdateSparks),&Parms);
    }
    DECLARE_CLASS(AONSImpactSparks,AEmitter,0,Onslaught)
    NO_DEFAULT_CONSTRUCTOR(AONSImpactSparks)
};


struct AONSDamagedEffect_eventUpdateDamagedEffect_Parms
{
    BITFIELD bFlame;
    FLOAT VelMag;
};
class ONSLAUGHT_API AONSDamagedEffect : public AEmitter
{
public:
    void eventUpdateDamagedEffect(BITFIELD bFlame, FLOAT VelMag)
    {
        AONSDamagedEffect_eventUpdateDamagedEffect_Parms Parms;
        Parms.bFlame=((bFlame) ? FIRST_BITFIELD : 0);
        Parms.VelMag=VelMag;
        ProcessEvent(FindFunctionChecked(ONSLAUGHT_UpdateDamagedEffect),&Parms);
    }
    DECLARE_CLASS(AONSDamagedEffect,AEmitter,0,Onslaught)
    NO_DEFAULT_CONSTRUCTOR(AONSDamagedEffect)
};


class ONSLAUGHT_API AONSRVWebProjectile : public AProjectile
{
public:
    class UClass* ProjectileEffectClass GCC_PACK(8);
    class AEmitter* ProjectileEffect;
    class AONSRVWebProjectileLeader* Leader;
    INT ProjNumber;
    FLOAT LastTickTime;
    BITFIELD bBeingSucked:1 GCC_PACK(4);
    class AActor* StuckActor GCC_PACK(8);
    FVector StuckNormal;
    INT BeamSubEmitterIndex;
    FLOAT ExplodeDelay;
    class USound* StuckSound;
    class UClass* ExplodeEffect;
    class USound* ExplodeSound;
    class UClass* ExtraDamageClass;
    FLOAT ExtraDamageMultiplier;
    DECLARE_CLASS(AONSRVWebProjectile,AProjectile,0|CLASS_NativeReplication,Onslaught)
	virtual INT* GetOptimizedRepList(BYTE* Recent, FPropertyRetirement* Retire, INT* Ptr, UPackageMap* Map, UActorChannel* Channel);
	void TickAuthoritative(FLOAT DeltaSeconds);
};


struct AONSRVWebProjectileLeader_eventDetonateWeb_Parms
{
};
class ONSLAUGHT_API AONSRVWebProjectileLeader : public AONSRVWebProjectile
{
public:
    FLOAT SpringLength GCC_PACK(4);
    FLOAT SpringStiffness;
    FLOAT StuckSpringStiffness;
    FLOAT SpringDamping;
    FLOAT SpringMaxForce;
    FLOAT SpringExplodeLength;
    FLOAT ProjVelDamping;
    FLOAT ProjStuckNeighbourVelDamping;
    FInterpCurve ProjGravityScale;
    BITFIELD bEnableSuckTargetForce:1 GCC_PACK(4);
    BITFIELD bSymmetricSuckTarget:1;
    BITFIELD bSuckFriendlyActor:1;
    BITFIELD bNoSuckFromBelow:1;
    BITFIELD bOnlySuckToDriven:1;
    TArrayNoInit<class UClass*> SuckTargetClasses GCC_PACK(8);
    FLOAT SuckTargetRange;
    FLOAT SuckTargetForce;
    FVector SuckTargetOffset;
    FLOAT SuckReduceVelFactor;
    BYTE ProjTeam;
    FLOAT FireTime GCC_PACK(4);
    TArrayNoInit<class AONSRVWebProjectile*> Projectiles;
    void eventDetonateWeb()
    {
        ProcessEvent(FindFunctionChecked(ONSLAUGHT_DetonateWeb),NULL);
    }
    DECLARE_CLASS(AONSRVWebProjectileLeader,AONSRVWebProjectile,0|CLASS_NativeReplication,Onslaught)
	INT* GetOptimizedRepList(BYTE* Recent, FPropertyRetirement* Retire, INT* Ptr, UPackageMap* Map, UActorChannel* Channel);
	void TryPreAllProjectileTick(FLOAT DeltaSeconds);
	void UpdateBeams(FLOAT DeltaSeconds);
	void ApplySpringForces(FLOAT DeltaSeconds);
};


class ONSLAUGHT_API AONSHeadlightCorona : public ALight
{
public:
    DECLARE_CLASS(AONSHeadlightCorona,ALight,0,Onslaught)
    NO_DEFAULT_CONSTRUCTOR(AONSHeadlightCorona)
};

struct ONSLAUGHT_API FONSWeaponAIInfo
{
    BITFIELD bTossed:1 GCC_PACK(4);
    BITFIELD bTrySplash:1;
    BITFIELD bLeadTarget:1;
    BITFIELD bInstantHit:1;
    BITFIELD bFireOnRelease:1;
    FLOAT aimerror GCC_PACK(4);
    FLOAT WarnTargetPct;
    FLOAT RefireRate;
};


struct AONSWeapon_eventFlashMuzzleFlash_Parms
{
};
struct AONSWeapon_eventAttemptFire_Parms
{
    class AController* C;
    BITFIELD bAltFire;
    BITFIELD ReturnValue;
};
struct AONSWeapon_eventOwnerEffects_Parms
{
};
struct AONSWeapon_eventClientSpawnHitEffects_Parms
{
};
class ONSLAUGHT_API AONSWeapon : public AActor
{
public:
    FName YawBone GCC_PACK(4);
    FLOAT YawStartConstraint;
    FLOAT YawEndConstraint;
    FLOAT YawConstraintDelta;
    FName PitchBone;
    INT PitchUpLimit;
    INT PitchDownLimit;
    FRotator CurrentAim;
    FVector WeaponFireLocation;
    FRotator WeaponFireRotation;
    FName WeaponFireAttachmentBone;
    FName GunnerAttachmentBone;
    FLOAT WeaponFireOffset;
    FLOAT DualFireOffset;
    FVector WeaponOffset;
    FRotator LastRotation;
    FLOAT RotationsPerSecond;
    BITFIELD bInstantRotation:1 GCC_PACK(4);
    BITFIELD bActive:1;
    BITFIELD bInstantFire:1;
    BITFIELD bDualIndependantTargeting:1;
    BITFIELD bShowChargingBar:1;
    BITFIELD bCallInstigatorPostRender:1;
    BITFIELD bForceCenterAim:1;
    BITFIELD bAimable:1;
    BITFIELD bDoOffsetTrace:1;
    BITFIELD bAmbientFireSound:1;
    BITFIELD bAmbientAltFireSound:1;
    BITFIELD bInheritVelocity:1;
    BITFIELD bIsAltFire:1;
    BITFIELD bIsRepeatingFF:1;
    BITFIELD bReflective:1;
    BITFIELD bShowAimCrosshair:1;
    BITFIELD bCorrectAim:1;
    FLOAT FireIntervalAimLock GCC_PACK(4);
    FLOAT AimLockReleaseTime;
    FVector CurrentHitLocation;
    FLOAT Spread;
    FLOAT AimTraceRange;
    FVector LastHitLocation;
    BYTE FlashCount;
    BYTE OldFlashCount;
    BYTE HitCount;
    BYTE OldHitCount;
    BYTE Team;
    class UMaterial* RedSkin GCC_PACK(8);
    class UMaterial* BlueSkin;
    FLOAT FireInterval;
    FLOAT AltFireInterval;
    FLOAT FireCountdown;
    class UClass* FlashEmitterClass;
    class AEmitter* FlashEmitter;
    class UClass* EffectEmitterClass;
    class AEmitter* EffectEmitter;
    class UClass* AmbientEffectEmitterClass;
    class AONSWeaponAmbientEmitter* AmbientEffectEmitter;
    class USound* FireSoundClass;
    FLOAT FireSoundVolume;
    FLOAT FireSoundRadius;
    FLOAT FireSoundPitch;
    class USound* AltFireSoundClass;
    FLOAT AltFireSoundVolume;
    FLOAT AltFireSoundRadius;
    class USound* RotateSound;
    FLOAT RotateSoundThreshold;
    FLOAT AmbientSoundScaling;
    FStringNoInit FireForce;
    FStringNoInit AltFireForce;
    class UClass* DamageType;
    INT DamageMin;
    INT DamageMax;
    FLOAT TraceRange;
    FLOAT Momentum;
    class UClass* ProjectileClass;
    class UClass* AltFireProjectileClass;
    TArrayNoInit<class AProjectile*> Projectiles;
    FVector ShakeRotMag;
    FVector ShakeRotRate;
    FLOAT ShakeRotTime;
    FVector ShakeOffsetMag;
    FVector ShakeOffsetRate;
    FLOAT ShakeOffsetTime;
    FONSWeaponAIInfo AIInfo[2];
    FFireProperties SavedFireProperties[2];
    FStringNoInit DebugInfo;
    DECLARE_FUNCTION(execLimitPitch);
    void eventFlashMuzzleFlash()
    {
        ProcessEvent(FindFunctionChecked(ONSLAUGHT_FlashMuzzleFlash),NULL);
    }
    BITFIELD eventAttemptFire(class AController* C, BITFIELD bAltFire)
    {
        AONSWeapon_eventAttemptFire_Parms Parms;
        Parms.ReturnValue=0;
        Parms.C=C;
        Parms.bAltFire=((bAltFire) ? FIRST_BITFIELD : 0);
        ProcessEvent(FindFunctionChecked(ONSLAUGHT_AttemptFire),&Parms);
        return Parms.ReturnValue;
    }
    void eventOwnerEffects()
    {
        ProcessEvent(FindFunctionChecked(ONSLAUGHT_OwnerEffects),NULL);
    }
    void eventClientSpawnHitEffects()
    {
        ProcessEvent(FindFunctionChecked(ONSLAUGHT_ClientSpawnHitEffects),NULL);
    }
    DECLARE_CLASS(AONSWeapon,AActor,0|CLASS_NativeReplication,Onslaught)
	INT* GetOptimizedRepList(BYTE* Recent, FPropertyRetirement* Retire, INT* Ptr, UPackageMap* Map, UActorChannel* Channel);
	virtual UBOOL Tick(FLOAT DeltaTime, enum ELevelTick TickType);
	virtual void PostNetReceive();
	FVector GetAimStart() const;
	virtual UBOOL SetAim(FVector HitLocation, FRotator ForwardRotation);
	INT LimitPitch(INT Pitch, FRotator ForwardRotation, INT WeaponYaw);
	void PostRender(FLevelSceneNode* SceneNode, FRenderInterface* RI);
	virtual FLOAT GetAmbientVolume(FLOAT Attenuation);
};


class ONSLAUGHT_API AONSLinkableWeapon : public AONSWeapon
{
public:
    class AONSWeapon* ChildWeapon GCC_PACK(8);
    DECLARE_CLASS(AONSLinkableWeapon,AONSWeapon,0,Onslaught)
	virtual UBOOL SetAim(FVector HitLocation, FRotator ForwardRotation);
};

#endif

AUTOGENERATE_FUNCTION(AONSWeapon,-1,execLimitPitch);

#ifndef NAMES_ONLY
#undef AUTOGENERATE_NAME
#undef AUTOGENERATE_FUNCTION
#endif

#if SUPPORTS_PRAGMA_PACK
#pragma pack (pop)
#endif


#ifdef NATIVE_DEFS_ONLY
DECLARE_NATIVE_TYPE(Onslaught,AONSWheeledCraft);
DECLARE_NATIVE_TYPE(Onslaught,AONSVehicle);
DECLARE_NATIVE_TYPE(Onslaught,AONSRVWebProjectileLeader);
DECLARE_NATIVE_TYPE(Onslaught,AONSRVWebProjectile);
DECLARE_NATIVE_TYPE(Onslaught,AONSWeaponAmbientEmitter);
DECLARE_NATIVE_TYPE(Onslaught,AONSWeaponPawn);
DECLARE_NATIVE_TYPE(Onslaught,AONSLinkableWeapon);
DECLARE_NATIVE_TYPE(Onslaught,AONSWeapon);
DECLARE_NATIVE_TYPE(Onslaught,AONSImpactSparks);
DECLARE_NATIVE_TYPE(Onslaught,AONSHeadlightCorona);
DECLARE_NATIVE_TYPE(Onslaught,AONSHeadlightProjector);
DECLARE_NATIVE_TYPE(Onslaught,AONSDamagedEffect);
DECLARE_NATIVE_TYPE(Onslaught,AONSTreadCraft);
DECLARE_NATIVE_TYPE(Onslaught,AONSPlaneCraft);
DECLARE_NATIVE_TYPE(Onslaught,AONSHoverCraft);
DECLARE_NATIVE_TYPE(Onslaught,AONSChopperCraft);

#define AUTO_INITIALIZE_REGISTRANTS_ONSLAUGHT \
	AONSWheeledCraft::StaticClass(); \
	AONSVehicle::StaticClass(); \
	AONSRVWebProjectileLeader::StaticClass(); \
	AONSRVWebProjectile::StaticClass(); \
	AONSWeaponAmbientEmitter::StaticClass(); \
	AONSWeaponPawn::StaticClass(); \
	AONSLinkableWeapon::StaticClass(); \
	AONSWeapon::StaticClass(); \
	GNativeLookupFuncs[Lookup++] = &FindOnslaughtAONSWeaponNative; \
	AONSImpactSparks::StaticClass(); \
	AONSHeadlightCorona::StaticClass(); \
	AONSHeadlightProjector::StaticClass(); \
	AONSDamagedEffect::StaticClass(); \
	AONSTreadCraft::StaticClass(); \
	AONSPlaneCraft::StaticClass(); \
	AONSHoverCraft::StaticClass(); \
	AONSChopperCraft::StaticClass(); \

#endif // NATIVE_DEFS_ONLY

#ifdef NATIVES_ONLY
NATIVE_INFO(AONSWeapon) GOnslaughtAONSWeaponNatives[] = 
{ 
	MAP_NATIVE(AONSWeapon,execLimitPitch)
	{NULL,NULL}
};
IMPLEMENT_NATIVE_HANDLER(Onslaught,AONSWeapon);

#endif // NATIVES_ONLY

#ifdef VERIFY_CLASS_SIZES
VERIFY_CLASS_SIZE_NODIE(AONSWheeledCraft)
VERIFY_CLASS_SIZE_NODIE(AONSVehicle)
VERIFY_CLASS_SIZE_NODIE(AONSRVWebProjectileLeader)
VERIFY_CLASS_SIZE_NODIE(AONSRVWebProjectile)
VERIFY_CLASS_SIZE_NODIE(AONSWeaponAmbientEmitter)
VERIFY_CLASS_SIZE_NODIE(AONSWeaponPawn)
VERIFY_CLASS_SIZE_NODIE(AONSLinkableWeapon)
VERIFY_CLASS_SIZE_NODIE(AONSWeapon)
VERIFY_CLASS_SIZE_NODIE(AONSImpactSparks)
VERIFY_CLASS_SIZE_NODIE(AONSHeadlightCorona)
VERIFY_CLASS_SIZE_NODIE(AONSHeadlightProjector)
VERIFY_CLASS_SIZE_NODIE(AONSDamagedEffect)
VERIFY_CLASS_SIZE_NODIE(AONSTreadCraft)
VERIFY_CLASS_SIZE_NODIE(AONSPlaneCraft)
VERIFY_CLASS_SIZE_NODIE(AONSHoverCraft)
VERIFY_CLASS_SIZE_NODIE(AONSChopperCraft)
#endif // VERIFY_CLASS_SIZES
